# -*- coding: utf-8 -*-
"""
@author: Andrei Sontag
"""


# Import required modules
import numpy as np
import pandas as pd
import os, fnmatch
import matplotlib.pyplot as plt
import matplotlib

os.chdir(r'./')

fileOfDirectory = os.listdir('.')
pattern = '*noabs.csv'
files = []
for filename in fileOfDirectory:
    if fnmatch.fnmatch(filename, pattern):
            files.append(filename)

stx = np.random.uniform(0,1)
sty = np.random.uniform(0,1-stx)

# Figures
# Create layout
layout = [
        ["A","E"],
        ["B","F"],
        ["C","G"],
        ["D","H"],
]

laylabels = ['A','B','C','D','E','F','G','H']

matplotlib.rcParams.update({'font.size': 15})

fig, axd = plt.subplot_mosaic(layout, figsize=(18,15),sharex=True)

rnds = np.arange(1,120)
rounds = 120

strv = []
for k in range(1,rounds+1):
    	strv = np.append(strv,r"no_abs.{0:.0f}.group.A_votes".format(k))

strvb = []
for k in range(1,rounds+1):
    	strvb = np.append(strvb,r"no_abs.{0:.0f}.group.B_votes".format(k))

for i,file in enumerate(files):
    df = pd.read_csv(file)
    
    N = int(file[:2])
    
    avotes1 = df[strv].to_numpy()
    avotes1 = avotes1[np.where(np.isnan(avotes1)==False)[0][0]]
    bvotes1 = df[strvb].to_numpy()
    bvotes1 = bvotes1[np.where(np.isnan(bvotes1)==False)[0][0]]
    
    axd[laylabels[i]].plot(rnds, avotes1[1:120], color='red',label='A votes')
    axd[laylabels[i]].plot(rnds, bvotes1[1:120], color='steelblue',label='B votes')
    axd[laylabels[i]].plot(rnds, N-avotes1[1:120]-bvotes1[1:120], color='#222021',label = 'Timeouts')
    #axd['A'].set_xlabel('rounds')
    axd[laylabels[i]].set_ylabel('# of votes')
    axd[laylabels[i]].set_title(file[:-10])
    
plt.tight_layout()
#plt.savefig('no_abs_timeseries.svg' % N, format='svg', dpi=300)